<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<xsl:template match="/">

<html>
<head>
<title>Alchemy CATALYST Report</title>

<link rel="stylesheet" href="Report_Styles/main.css" type="text/css"/>
<script language="JavaScript1.2">

<![CDATA[

var totalsTTK = "";
var totals = "";
var processed_totals = "";

var layersStatus ="";

	var resource_name = "";
	var words = 0;
	var xfr = 0;
	var xso = 0;
	var xxated = 0;
	var xxable = 0;	
	var resource_number = 0;

function processTotals()
{
	var totalsArray = totals.split("||");

	for (i = 0 ; i < totalsArray.length ; i++)
	{
		if (totalsArray[i].length > 0)
		{
			var tempArray = totalsArray[i].split("*");

			resource_name = tempArray[0];
			words = tempArray[1];
			xfr = tempArray[2];
			xso = tempArray[3];
			xxated = tempArray[4];
			xxable = tempArray[5];			
			resource_number = 1;
			
			for (j = i+1 ; j < totalsArray.length ; j++ )
			{
				if (totalsArray[j].length > 0)
				{
					tempArray = totalsArray[j].split("*");
					// if we find another occurrence of the same resource type, we add up words counts
					if ( tempArray[0] == resource_name )
					{
						words = 1*words + 1*tempArray[1];
						xfr = 1*xfr + 1*tempArray[2];
						xso = 1*xso + 1*tempArray[3];
						xxated = 1*xxated + 1*tempArray[4];
						xxable = 1*xxable + 1*tempArray[5];
						resource_number++;
						
						//erase the string already processed
						totalsArray[j] = "";
					}
				}
			}
			
			//create new string and add it to processed_totals
			processed_totals = processed_totals + "||" + resource_name + "*" + words + "*" + xfr + "*" + xso + "*" + xxated + "*" + xxable + "*" +resource_number;
		}
	}
}

function display_resources_summary()
{
	var folderPresent = false;
	//write TTK info
	var processed_TTKArray_folders = totalsTTK.split("||");

	words = 0;
	xfr = 0;
	xso = 0;
	xxated = 0;
	xxable = 0;	
	resource_number = 0;

	for (i = 0 ; i < processed_TTKArray_folders.length ; i++)
	{
		if (processed_TTKArray_folders[i].length > 0)	
		{
			var processed_TTKArray = processed_TTKArray_folders[i].split("*");
			if (processed_TTKArray.length > 1)
			{
				folderPresent = true;
				words = 1*words + 1*processed_TTKArray[1];
				xfr = 1*xfr + 1*processed_TTKArray[2];
				xso = 1*xso + 1*processed_TTKArray[3];
				xxated = 1*xxated + 1*processed_TTKArray[4];
				xxable = 1*xxable + 1*processed_TTKArray[5];		
		
			}
		}
	}
	
	if (folderPresent == true)
	{
		document.write('<tr class="text">')
		document.write('<td align="right">');				
		document.write("Entire Report");					
		document.write('</td>');

		document.write('<td align="right">');				
		document.write(words);					
		document.write('</td>');				
				
		document.write('<td align="right">');				
		document.write(xxable);					
		document.write('</td>');				
				
		document.write('<td align="right">');				
		document.write(xxated);					
		document.write('</td>');				
		
		document.write('<td align="right">');				
		document.write(xfr);					
		document.write('</td>');				
				
		document.write('<td align="right">');				
		document.write(xso);					
		document.write('</td>');
		
		document.write('<td align="right">');				
		document.write(xxable*1 - xxated*1);					
		document.write('</td>');			
		document.write('</tr>');			
	}

	//write all resources
	var processed_totalsArray = processed_totals.split("||");
	for (i = 0 ; i < processed_totalsArray.length ; i++)
	{
		if (processed_totalsArray[i].length >1)
		{
			tempArray = processed_totalsArray[i].split("*");

			resource_name = tempArray[0];
			words = tempArray[1];
			xfr = tempArray[2];
			xso = tempArray[3];
			xxated = tempArray[4];
			xxable = tempArray[5];			
			resource_number = tempArray[6];
			
			if (resource_name != "folder")
			{
				if ( (i % 2) != 0)
					{document.write('<tr class="text">')}
				else
					{document.write('<tr class="text" bgcolor="#B3A06B">');}
				document.write('<td align="right">');				
				document.write(resource_name);					
				document.write('</td>');

				document.write('<td align="right">');				
				document.write(words);					
				document.write('</td>');				
				
				document.write('<td align="right">');				
				document.write(xxable);					
				document.write('</td>');				
				
				document.write('<td align="right">');				
				document.write(xxated);					
				document.write('</td>');				
				
				document.write('<td align="right">');				
				document.write(xfr);					
				document.write('</td>');				
				
				document.write('<td align="right">');				
				document.write(xso);					
				document.write('</td>');
				
				document.write('<td align="right">');				
				document.write(xxable*1 - xxated*1);					
				document.write('</td>');												
				
				document.write('</tr>');									
			}
		}
	}
}

/* Functions that swaps images. */
function MM_swapImage() { //v3.0
  var i,j=0,x,a=MM_swapImage.arguments; document.MM_sr=new Array; for(i=0;i<(a.length-2);i+=3)
   if ((x=MM_findObj(a[i]))!=null){document.MM_sr[j++]=x; if(!x.oSrc) x.oSrc=x.src; x.src=a[i+2];}
}
function MM_swapImgRestore() { //v3.0
  var i,x,a=document.MM_sr; for(i=0;a&&i<a.length&&(x=a[i])&&x.oSrc;i++) x.src=x.oSrc;
}

/* Functions that handle preload. */
function MM_preloadImages() { //v3.0
 var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
   var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
   if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}

function MM_findObj(n, d) { //v4.01
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && d.getElementById) x=d.getElementById(n); return x;
}

function tmt_DivAlign(theDiv,h,v,hPx,vPx){
	var obj,fun,dw,dh,lw,lh,x,y;
	fun = (document.getElementById) ? "document.getElementById" : "MM_findObj";
	obj = (document.getElementById) ? document.getElementById(theDiv) : MM_findObj(theDiv);
	if(obj){if(document.all){
	dw = document.body.clientWidth;dh = document.body.clientHeight;}
	else{dw = innerWidth;dh = innerHeight;}
	if(document.layers){lw = obj.clip.width;lh = obj.clip.height;}else{
	lw = obj.style.width.replace("px","");lh = obj.style.height.replace("px","");}
	x = (document.layers) ? ".left" : ".style.left";
	y = (document.layers) ? ".top" : ".style.top";
	if(h == "l"){eval(fun+"('"+theDiv+"')"+x+"="+hPx);}
	if(h == "c"){eval(fun+"('"+theDiv+"')"+x+"="+dw+"/2-"+lw+"/2");}
	if(h == "r"){eval(fun+"('"+theDiv+"')"+x+"="+dw+"-"+lw+"-"+hPx);}
	if(v == "t"){eval(fun+"('"+theDiv+"')"+y+"="+vPx);}
	if(v == "m"){eval(fun+"('"+theDiv+"')"+y+"="+dh+"/2-"+lh+"/2");}
	if(v == "b"){eval(fun+"('"+theDiv+"')"+y+"="+dh+"-"+lh+"-"+vPx);}}
}


function MM_showHideLayers() { //v3.0
  var i,p,v,obj,args=MM_showHideLayers.arguments;
  for (i=0; i<(args.length-2); i+=3) if ((obj=MM_findObj(args[i]))!=null) { v=args[i+2];
    if (obj.style) { obj=obj.style; v=(v=='show')?'visible':(v='hide')?'hidden':v; }
    obj.visibility=v; }
}

var goToAnchor="";

function doDisplay()
{
	if (document.main.index.selectedIndex !=0)
		{
			goToAnchor = "#" + document.main.index.options[document.main.index.selectedIndex].value;
		}
	else
	{
		goToAnchor = "#top";
	}
}


function doDisplayViewLayer(layer) 
{
	if (layer=="compact") 
	{
		MM_showHideLayers('verboseLayer','','hide') ;
		tmt_DivResize('verboseLayer','99%','1');
		MM_changeProp('verboseLayer','','style.overflow','hidden','DIV'); 
		MM_showHideLayers('compactLayer','','show');
	 }
	else
	{
		CollapseAll();
		MM_showHideLayers('compactLayer','','hide') ;
		tmt_DivResize('verboseLayer','100%','100');
		MM_changeProp('verboseLayer','','style.overflow','visible','DIV'); 
		MM_showHideLayers('verboseLayer','','show');
		document.main.index.selectedIndex = 0;
	}

}

function tmt_findObj(n){
	var x,t; if((n.indexOf("?"))>0&&parent.frames.length){t=n.split("?");
	x=eval("parent.frames['"+t[1]+"'].document.getElementById('"+t[0]+"')");
	}else{x=document.getElementById(n)}return x;
}

function tmt_DivResize(theDiv,w,h){
    var fun = (document.getElementById) ? "tmt_findObj" : "MM_findObj";
	var obj = eval(fun+"(theDiv)");
	if(document.layers && obj)obj.resizeTo(w, h);
  	else{if(obj)obj.style.width = w;obj.style.height = h;}
}

function MM_changeProp(objName,x,theProp,theValue) { //v3.0
  var obj = MM_findObj(objName);
  if (obj && (theProp.indexOf("style.")==-1 || obj.style)) eval("obj."+theProp+"='"+theValue+"'");
}


function replaceSubstring(inputString, fromString, toString) {
   // Goes through the inputString and replaces every occurrence of fromString with toString
   var temp = inputString;
   if (fromString == "") {
      return inputString;
   }
   if (toString.indexOf(fromString) == -1) { // If the string being replaced is not a part of the replacement string (normal situation)
      while (temp.indexOf(fromString) != -1) {
         var toTheLeft = temp.substring(0, temp.indexOf(fromString));
         var toTheRight = temp.substring(temp.indexOf(fromString)+fromString.length, temp.length);
         temp = toTheLeft + toString + toTheRight;
      }
   } else { // String being replaced is part of replacement string (like "+" being replaced with "++") - prevent an infinite loop
      var midStrings = new Array("~", "`", "_", "^", "#");
      var midStringLen = 1;
      var midString = "";
      // Find a string that doesn't exist in the inputString to be used
      // as an "inbetween" string
      while (midString == "") {
         for (var i=0; i < midStrings.length; i++) {
            var tempMidString = "";
            for (var j=0; j < midStringLen; j++) { tempMidString += midStrings[i]; }
            if (fromString.indexOf(tempMidString) == -1) {
               midString = tempMidString;
               i = midStrings.length + 1;
            }
         }
      } // Keep on going until we build an "inbetween" string that doesn't exist
      // Now go through and do two replaces - first, replace the "fromString" with the "inbetween" string
      while (temp.indexOf(fromString) != -1) {
         var toTheLeft = temp.substring(0, temp.indexOf(fromString));
         var toTheRight = temp.substring(temp.indexOf(fromString)+fromString.length, temp.length);
         temp = toTheLeft + midString + toTheRight;
      }
      // Next, replace the "inbetween" string with the "toString"
      while (temp.indexOf(midString) != -1) {
         var toTheLeft = temp.substring(0, temp.indexOf(midString));
         var toTheRight = temp.substring(temp.indexOf(midString)+midString.length, temp.length);
         temp = toTheLeft + toString + toTheRight;
      }
   } // Ends the check to see if the string being replaced is part of the replacement string or not
   return temp; // Send the updated string back to the user
} // Ends the "replaceSubstring" function


function CollapseAll()
{
	var icon = "";
	var layer = "";
	var ch = '*';
	var cur = 0;
	var i = layersStatus.indexOf('g');
	while (i != -1)
	{
		cur = i +1;
		ch = layersStatus.charAt(cur);
		while (ch != 's' && ch != 'h')
		{
			cur++;
			ch = layersStatus.charAt(cur);
		}
		if (ch == 's')//layer is visible , so hide it and change string
		{
			layer = layersStatus.substring(i, cur);
			MM_showHideLayers(layer,'','hide') ;
			tmt_DivResize(layer,'100%','1');
			MM_changeProp(layer,'','style.overflow','hidden','DIV'); 

			layersStatus = replaceSubstring(layersStatus, layer +"s" , layer+"h");

			icon = "icon" + layer;
			MM_swapImage(icon,'','Report_Styles/pnode.gif',1);

		}
		i = layersStatus.indexOf('g', i+1);
	}
}


function OpenAll()
{
	var layer2 = "";
	var ch2 = '*';
	var cur = 0;
	var i = layersStatus.indexOf('g');
	while (i != -1)
	{
		cur = i +1;
		ch2 = layersStatus.charAt(cur);
		while (ch2 != 's' && ch2 != 'h')
		{
			cur++;
			ch2 = layersStatus.charAt(cur);
		}
		if (ch2 == 'h')//layer is hidden , so show it and change string
		{
			layer2 = layersStatus.substring(i, cur);

			//tmt_DivResize(layer2,'100%','30');
			MM_changeProp(layer2,'','style.overflow','visible','DIV'); 
			MM_showHideLayers(layer2,'','show') ;

			layersStatus = replaceSubstring(layersStatus, layer2 +"h" , layer2+"s");
		}
		i = layersStatus.indexOf('g', i+1);
	}
}

function ExpandLayer( LayerId)
{
	var icon ="";

	if ( layersStatus.indexOf(LayerId +"h") != -1 )	//layer is hidden
	{
		tmt_DivResize(LayerId,'100%','20');
		MM_changeProp(LayerId,'','style.overflow','visible','DIV'); 
//		MM_changeProp(LayerId,'','style.backgroundColor','#FFFF99','DIV');
//		MM_changeProp(LayerId,'','style.layer-background-color','#FFFF99','DIV');
		MM_showHideLayers(LayerId,'','show') ;
		layersStatus = replaceSubstring( layersStatus , LayerId +"h" , LayerId +"s");
		icon = "icon" + LayerId;
		MM_swapImage(icon,'','Report_Styles/mnode.gif',1);
	}
	else
	{
		tmt_DivResize(LayerId,'100%','1');
		MM_changeProp(LayerId,'','style.overflow','hidden','DIV'); 
		MM_showHideLayers(LayerId,'','hide') ;
		layersStatus = replaceSubstring( layersStatus , LayerId +"s" , LayerId +"h");

		icon = "icon" + LayerId;
		MM_swapImage(icon,'','Report_Styles/pnode.gif',1);
	}

	// MM_setTextOfLayer( LayerId ,'' , text);
}







]]>

</script>
</head>

<body bgcolor="#FFFFFF" text="#B3A06B" leftmargin="10" marginheight="5" marginwidth="5" topmargin="0"  onload="MM_preloadImages('Report_Styles/mnode.gif');document.main.reset()" ><a href="top"></a>
<form name="main">

<xsl:for-each select="/xliff/file//group">
<script>
<xsl:text>layersStatus = layersStatus +"</xsl:text><xsl:value-of select="@id"/><xsl:text>h";</xsl:text>
</script>
</xsl:for-each>

<xsl:choose>
<xsl:when test="/xliff/file/@original = 'CATALYST Report'">
<xsl:call-template name="compact_template"/>
</xsl:when>
<xsl:when test="/xliff/file/@original = 'CATALYST Statistics'">
<xsl:call-template name="statistics_template"/>
</xsl:when>
<xsl:when test="/xliff/file/@original = 'CATALYST Report - Verbose'">
<xsl:call-template name="verbose_template"/>
</xsl:when>
<xsl:when test="/xml/file/@original = 'CATALYST Compare Report'">
<xsl:call-template name="compare_template"/>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="validate_template"/>
</xsl:otherwise>
</xsl:choose>
</form>
</body>
</html>
</xsl:template>



<!--********************STATISTICS TEMPLATE START******************************-->
<xsl:template name="statistics_template" >
<table border="0" width="100%" cellpadding="5" cellspacing="5">
<tr>
<td valign="top" align="left"><img src="Report_Styles/stats_header.gif" vspace="15" border="0"/></td>
</tr>
</table>
<xsl:call-template name="compact_view"/>
<script>tmt_DivAlign('compactLayer','','t','0','50');</script>
<script>MM_showHideLayers('compactLayer','','show');</script>
</xsl:template>


<!--********************VALIDATE TEMPLATE START******************************-->
<xsl:template name="validate_template" >
<table border="0" width="100%" cellpadding="5" cellspacing="5">
<tr>
<td valign="top"><img src="Report_Styles/alchemybanner.jpg" vspace="10" border="0"/></td>
<td><img src="Report_Styles/pixel.gif" width="30" height="1" border="0"/></td>
<td valign="bottom"><img src="Report_Styles/bannertext30.jpg"  border="0" vspace="8"/><br/>
<img src="Report_Styles/pixel.gif" width="114" height="30" border="0" vspace="20" hspace="5"/><img src="Report_Styles/pixel.gif" width="114" height="30" border="0" vspace="20" hspace="15"/></td>
</tr>
</table>
<xsl:for-each select="//group">
<xsl:choose>
<xsl:when test="text() != ''">
<xsl:call-template name="strings_validate_template"/>
</xsl:when>
<xsl:when test="segment">
<xsl:call-template name="strings_validate_template"/>
</xsl:when>
</xsl:choose>
</xsl:for-each>
</xsl:template>



<!--********************COMPARE TEMPLATE START******************************-->
<xsl:template name="compare_template" >
<table border="0" width="100%" cellpadding="5" cellspacing="5">
<tr>
<td valign="top"><img src="Report_Styles/alchemybanner.jpg"  vspace="10" border="0"/></td>
<td><img src="Report_Styles/pixel.gif" width="30" height="1" border="0"/></td>
<td valign="bottom"><img src="Report_Styles/bannertext30.jpg" border="0" vspace="8"/><br/>
<img src="Report_Styles/pixel.gif" width="114" height="30" border="0" vspace="20" hspace="5"/><img src="Report_Styles/pixel.gif" width="114" height="30" border="0" vspace="20" hspace="15"/></td>
</tr>
</table>
<xsl:for-each select="/xml/file/body/group">
<xsl:choose>
<xsl:when test="@resname=''">
	<xsl:for-each select="group[@resname !='']">
		<xsl:call-template name="strings_compare_template"/>	
	</xsl:for-each>
</xsl:when>

<xsl:otherwise>
	<xsl:call-template name="strings_compare_template"/>	
</xsl:otherwise>
</xsl:choose>
</xsl:for-each>
</xsl:template>



<!--********************STRINGS COMPARE TEMPLATE START******************************-->
<xsl:template name="strings_compare_template" >
<a><xsl:attribute name="name"><xsl:value-of select="@id" /></xsl:attribute></a>
<br/>
<table cellspacing="0" cellpadding="3" border="0" width="100%">
<tr class="text" >
    <td bgcolor="#696745" colspan="3"><font color="White"><b>

<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="@resname"/><img src="Report_Styles/pixel.gif" width="30" height="5" border="0"/> compared to file <img src="Report_Styles/pixel.gif" width="30" height="5" border="0"/><img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="@compare-file"/>

</b></font></td>
	
<td valign="bottom" width="30"><a href="#top"><img alt="Top of page" src="Report_Styles/arrow_up_red.gif" width="12" height="12" border="0"/></a><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><a><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="@id" /></xsl:attribute><img src="Report_Styles/arrow_down.gif" alt="Next element" width="12" height="12" border="0"/></a></td>
</tr>

<tr>
<td colspan="3">
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="textsmall" bgcolor="#f7f7f7">
    <td width="100%" align="right"><img src="Report_Styles/pixel.gif"  width="12" height="12" border="0"/></td>
</tr>
<tr class="text" bgcolor="#f7f7f7">
    <td  align="left">
	<xsl:if test="text() != ''">
	<xsl:value-of  select="text()"/>
	</xsl:if>
	</td>
</tr>
</table>
</td>
<td></td>
</tr>

<tr class="text" >
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
    <td bgcolor="#ffffff" class="text" colspan="2"></td>
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
</tr>

<xsl:for-each select="error">
<tr>
<td class="text" width="2%"></td>
<xsl:choose>
<xsl:when test="position() mod 2 != 0">
<td class="text" bgcolor="#f7f7f7" width="74%" colspan="2">
	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	</xsl:choose>
</td>
</xsl:when>

<xsl:otherwise>
<td class="text" bgcolor="#ffffff" width="74%" colspan="2">

	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	</xsl:choose>

</td>
</xsl:otherwise>
</xsl:choose>

<td valign="bottom" width="4%"><xsl:if test="position() mod 5 = 0"><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Top of element" src="Report_Styles/arrow_up.gif" width="12" height="12" border="0"/></xsl:element><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Next element" src="Report_Styles/arrow_down.gif" width="12" height="12" border="0"/></xsl:element></xsl:if ></td>
</tr>
</xsl:for-each>





<xsl:for-each select="group[error]">
<tr class="text" >
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
    <td bgcolor="#696745" colspan="2"><font color="White"><b>

<img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/><xsl:value-of select="@restype"/>

</b></font></td>
	
<td valign="bottom" width="30"><a href="#top"><img alt="Top of page" src="Report_Styles/arrow_up_red.gif" width="12" height="12" border="0"/></a><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><a><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="@id" /></xsl:attribute><img src="Report_Styles/arrow_down.gif" alt="Next element" width="12" height="12" border="0"/></a></td>
</tr>


<tr>
<td class="text" width="2%"></td>
<xsl:choose>
<xsl:when test="position() mod 2 != 0">
<td class="text" bgcolor="#f7f7f7" width="74%" colspan="2">
	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	</xsl:choose>
</td>
</xsl:when>

<xsl:otherwise>
<td class="text" bgcolor="#ffffff" width="74%" colspan="2">

	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	</xsl:choose>

</td>
</xsl:otherwise>
</xsl:choose>

<td valign="bottom" width="4%"><xsl:if test="position() mod 5 = 0"><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Top of element" src="Report_Styles/arrow_up.gif" width="12" height="12" border="0"/></xsl:element><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Next element" src="Report_Styles/arrow_down.gif" width="12" height="12" border="0"/></xsl:element></xsl:if ></td>
</tr>



<xsl:for-each select="error">
<tr>
<td class="text" width="2%"></td>
<xsl:choose>
<xsl:when test="position() mod 2 != 0">
<td class="text" bgcolor="#f7f7f7" width="74%" colspan="2">
	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	</xsl:choose>
</td>
</xsl:when>

<xsl:otherwise>
<td class="text" bgcolor="#ffffff" width="74%" colspan="2">

	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	</xsl:choose>

</td>
</xsl:otherwise>
</xsl:choose>

<td valign="bottom" width="4%"><xsl:if test="position() mod 5 = 0"><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Top of element" src="Report_Styles/arrow_up.gif" width="12" height="12" border="0"/></xsl:element><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Next element" src="Report_Styles/arrow_down.gif" width="12" height="12" border="0"/></xsl:element></xsl:if ></td>
</tr>
</xsl:for-each>

</xsl:for-each>

</table>
<xsl:element name="a"><xsl:attribute name="name"><xsl:text>end</xsl:text><xsl:value-of select="@id" /></xsl:attribute></xsl:element>
</xsl:template>






<!--********************STRINGS VALIDATE TEMPLATE START******************************-->
<xsl:template name="strings_validate_template" >
<a><xsl:attribute name="name"><xsl:value-of select="@id" /></xsl:attribute></a>
<br/>
<table cellspacing="0" cellpadding="3" border="0" width="100%">
<tr class="text" >
    <td bgcolor="#696745" colspan="3"><font color="White"><b>
<xsl:choose>
<xsl:when test="../@restype='folder'">
	<xsl:for-each select="..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each>
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="@resname"/>
</xsl:when >

<xsl:when test="../../@restype ='folder'">
	<xsl:for-each select="../..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each><img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="@resname !=''">
<xsl:value-of select="@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >


<xsl:when test="../../../@restype ='folder'">
	<xsl:for-each select="../../..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each><img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="../@resname !=''">
<xsl:value-of select="../@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="../@restype"/><xsl:text> : </xsl:text><xsl:value-of select="@resname"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >


<xsl:when test="name(..) = 'body'">
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="@resname"/>
</xsl:when >


<xsl:when test="name(../..) = 'body'">
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="@resname !=''">
<xsl:value-of select="@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >



<xsl:when test="name(../../..) = 'body'">
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="../@resname !=''">
<xsl:value-of select="../@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="../@restype"/><xsl:text> : </xsl:text><xsl:value-of select="@resname"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >


</xsl:choose>
</b></font></td>
	
<td valign="bottom" width="30"><a href="#top"><img alt="Top of page" src="Report_Styles/arrow_up_red.gif" width="12" height="12" border="0"/></a><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><a><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="@id" /></xsl:attribute><img src="Report_Styles/arrow_down.gif" alt="Next element" width="12" height="12" border="0"/></a></td>
</tr>

<tr>
<td colspan="3">
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="textsmall" bgcolor="#f7f7f7">
    <td width="100%" align="right"><img src="Report_Styles/pixel.gif"  width="12" height="12" border="0"/></td>
</tr>
<tr class="text" bgcolor="#f7f7f7">
    <td  align="left">
	<xsl:if test="text() != ''">
	<xsl:value-of  select="text()"/>
	</xsl:if>
	</td>
</tr>
</table>
</td>
<td></td>
</tr>

<tr class="text" >
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
    <td bgcolor="#ffffff" class="text"><b>String ID</b></td>
    <td bgcolor="#ffffff" class="text"><b>Validation Diagnosis</b></td>
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
</tr>

<xsl:for-each select="segment">
<tr>
<td class="text" width="6%"></td>
<xsl:choose>
<xsl:when test="position() mod 2 != 0">
<td class="text" bgcolor="#f7f7f7" width="20%"><xsl:value-of select="@id"/></td>
<td class="text" bgcolor="#f7f7f7" width="70%">
	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	<xsl:when test="error">
		<xsl:for-each select="error">
			<xsl:value-of select="text()"/>
			<br/>
		</xsl:for-each>
	</xsl:when>
	</xsl:choose>

</td>
</xsl:when>

<xsl:otherwise>
<td class="text" bgcolor="#ffffff" width="20%"><xsl:value-of select="@id"/></td>
<td class="text" bgcolor="#ffffff" width="70%">

	<xsl:choose>
	<xsl:when test="text() !=''">
	<xsl:value-of select="text()"/>
	</xsl:when>
	<xsl:when test="error">
		<xsl:for-each select="error">
			<xsl:value-of select="text()"/>
			<br/>
		</xsl:for-each>
	</xsl:when>
	</xsl:choose>

</td>
</xsl:otherwise>
</xsl:choose>


<td valign="bottom" width="4%"><xsl:if test="position() mod 5 = 0"><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Top of element" src="Report_Styles/arrow_up.gif" width="12" height="12" border="0"/></xsl:element><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Next element" src="Report_Styles/arrow_down.gif" width="12" height="12" border="0"/></xsl:element></xsl:if ></td>
</tr>

</xsl:for-each>
</table>
<xsl:element name="a"><xsl:attribute name="name"><xsl:text>end</xsl:text><xsl:value-of select="@id" /></xsl:attribute></xsl:element>
</xsl:template>






<!--********************COMPACT TEMPLATE START******************************-->
<xsl:template name="compact_template" >
<table border="0" width="100%" cellpadding="5" cellspacing="5">
<tr>
<td valign="top"><img src="Report_Styles/alchemybanner.jpg" vspace="10" border="0"/></td>
<td><img src="Report_Styles/pixel.gif" width="30" height="1" border="0"/></td>
<td valign="bottom"><img src="Report_Styles/bannertext30.jpg" width="195" vspace="8"/><br/>
<img src="Report_Styles/pixel.gif" width="114" height="30" border="0" vspace="20" hspace="5"/><img src="Report_Styles/pixel.gif" width="114" height="30" border="0" vspace="20" hspace="15"/></td>
</tr>
</table>
<!--<font face="Arial" color="Gray" size="2"><b>Report created on: <xsl:value-of select="/xliff/file/@date"/></b></font>-->
<xsl:call-template name="compact_view"/>
<script>MM_showHideLayers('compactLayer','','show');</script>
</xsl:template>

<!--********************TOTAL TEMPLATE START******************************-->
<xsl:template name="total_template" >
<script>
<xsl:for-each select="/xliff/file/body/group[@restype='folder']">
<xsl:text>totalsTTK = totalsTTK +"||</xsl:text><xsl:value-of select="@restype"/><xsl:text>";</xsl:text>
<xsl:text>totalsTTK = totalsTTK +"*</xsl:text><xsl:value-of select="count-group/count[@unit='words']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-fr']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-so']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-xated']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-xable']"/>
<xsl:text>";</xsl:text>
</xsl:for-each>

<xsl:for-each select="/xliff/file//group[@restype]">

<xsl:if test="@restype='XmlFileType'">
	<xsl:if test="../@restype!='XmlFileType'">
	<xsl:text>totals = totals +"||</xsl:text><xsl:value-of select="@restype"/><xsl:text>";</xsl:text>
	<xsl:text>totals = totals +"*</xsl:text><xsl:value-of select="count-group/count[@unit='words']"/>
	<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-fr']"/>
	<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-so']"/>
	<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-xated']"/>
	<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-xable']"/>
	<xsl:text>";</xsl:text>
	</xsl:if>

</xsl:if>

<xsl:if test="@restype!='XmlFileType'">
<xsl:text>totals = totals +"||</xsl:text><xsl:value-of select="@restype"/><xsl:text>";</xsl:text>
<xsl:text>totals = totals +"*</xsl:text><xsl:value-of select="count-group/count[@unit='words']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-fr']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-so']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-xated']"/>
<xsl:text>*</xsl:text><xsl:value-of select="count-group/count[@count-type='x-xable']"/>
<xsl:text>";</xsl:text>
</xsl:if>




</xsl:for-each>

<xsl:text>totals = totals +"||";</xsl:text>
processTotals();
</script>
<table width="100%" border="1" cellspacing="0" cellpadding="0" bgcolor="Gray">
<tr>
<td>
<table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="White">
<tr class="textsmall" bgcolor="#696745">
    <td colspan="8" align="left" valign="top"><b><font color="white">Summary Report by Resource Type</font></b></td>
</tr>	
<tr class="textsmall" bgcolor="#f7f7f7">
    <td width="12%" align="right" valign="top"><b>Resource type</b></td>
<!--    <td width="12%" align="right" valign="top"><b>Resource #</b></td>-->
    <td width="12%" align="right" valign="top"><b>Words</b></td>
    <td width="12%" align="right" valign="top"><b>Translatable</b></td>
    <td width="14%" align="right" valign="top"><b>Translated</b></td>
    <td width="12%" align="right" valign="top"><b>For Review</b></td>
    <td width="12%" align="right" valign="top"><b>Signed Off</b></td>
    <td width="14%" align="right" valign="top"><b>Not Translated</b></td>		
</tr>
<script>
display_resources_summary();
</script>
</table>
</td>
</tr>
</table>
<br/><br/>

</xsl:template>


<!--********************VERBOSE TEMPLATE START******************************-->
<xsl:template name="verbose_template" >
<table border="0" width="100%" cellpadding="5" cellspacing="5">
<tr>
<td valign="top"><img src="Report_Styles/alchemybanner.jpg"  vspace="10" border="0"/></td>
<td><img src="Report_Styles/pixel.gif" width="30" height="1" border="0"/></td>
<td valign="bottom"><img src="Report_Styles/bannertext30.jpg"  border="0" vspace="8"/><br/>
<a onFocus="if(this.blur)this.blur();" href="Javascript:doDisplayViewLayer('compact')"><img src="Report_Styles/summaryreportbutton.jpg" width="114" height="30" border="0" vspace="20" hspace="5"/></a><a onFocus="if(this.blur)this.blur();" href="Javascript:doDisplayViewLayer('verbose')"><img src="Report_Styles/verbosereportbutton.jpg" width="114" height="30" border="0" vspace="20" hspace="15"/></a></td>
</tr>
</table>

<xsl:call-template name="verbose_view"/>
<script>
doDisplayViewLayer();

</script>
</xsl:template>


<!--********************VERBOSE VIEW TEMPLATE START******************************-->
<xsl:template name="verbose_view" >
<xsl:call-template name="verbose_layer"/>
<xsl:call-template name="compact_layer"/>
</xsl:template>



<xsl:template name="verbose_layer" >
<!--******************************VERBOSE LAYER ******************************-->
<div id="verboseLayer" style="position:absolute; width:99%; height:115px; top:130px; z-index:1; visibility: hidden">
<table cellspacing="0" cellpadding="3" border="0" width="100%">
<tr>
<td class="text" align="right">
<a><xsl:attribute name="name"><xsl:value-of select="@id" /></xsl:attribute></a>
<br/><br/><select name="index" >
<option value="" selected="selected" >Select...</option>
<xsl:for-each select="//group[trans-unit]">
<xsl:choose>


<xsl:when test="../@restype='folder'">
<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute> <xsl:for-each select="..">
		<xsl:call-template name="write_path_to_folder"/>
	</xsl:for-each><xsl:value-of select="@resname"/></option>
</xsl:when >


<xsl:when test="name(..) = 'body'">
<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute> <xsl:value-of select="@resname"/></option>
</xsl:when >



<xsl:when test="../../@restype ='folder'">
<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
	<xsl:for-each select="../..">
		<xsl:call-template name="write_path_to_folder"/>
	</xsl:for-each><xsl:value-of select="../@resname"/><xsl:text> / </xsl:text>
<xsl:choose>
<xsl:when test="@resname !=''">
<xsl:value-of select="@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</option>
</xsl:when >



<xsl:when test="name(../..) = 'body'">
<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
<xsl:value-of select="../@resname"/><xsl:text> / </xsl:text>
<xsl:choose>
<xsl:when test="@resname !=''">
<xsl:value-of select="@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</option>
</xsl:when >


<xsl:when test="../../../@restype ='folder'">
<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
	<xsl:for-each select="../../..">
		<xsl:call-template name="write_path_to_folder"/>
	</xsl:for-each><xsl:value-of select="../../@resname"/><xsl:text> / </xsl:text>
<xsl:choose>
<xsl:when test="../@resname !=''">
<xsl:value-of select="../@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="../@restype"/><xsl:text> : </xsl:text><xsl:value-of select="@resname"/>
</xsl:otherwise>
</xsl:choose>
</option>
</xsl:when >


<xsl:when test="name(../../..) = 'body'">
<option><xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
	<xsl:value-of select="../../@resname"/><xsl:text> / </xsl:text>
<xsl:choose>
<xsl:when test="../@resname !=''">
<xsl:value-of select="../@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="../@restype"/><xsl:text> : </xsl:text><xsl:value-of select="@resname"/>
</xsl:otherwise>
</xsl:choose>
</option>
</xsl:when >


</xsl:choose>
</xsl:for-each>
</select> <a href="#top" onclick="doDisplay(); this.href=goToAnchor; "><img src="Report_Styles/gotobutton20.jpg" width="35" height="20" border="0" vspace="20" hspace="10" align="absmiddle"/></a>
</td>
<td width="25"></td>
</tr>
</table>
<br/>
<xsl:for-each select="//group[trans-unit]">
<xsl:call-template name="strings_template">
</xsl:call-template> 
</xsl:for-each>
</div>
</xsl:template>


<!--****************************** COMPACT LAYER ******************************-->
<xsl:template name="compact_layer" >
<div id="compactLayer" style="position:absolute; width:99%; height:115px; top:130px; z-index:1; visibility: hidden">
<div class="text" align="right"><a href="#" onclick="CollapseAll();"><b>Collapse All</b></a></div>
<br/>
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="textsmall" bgcolor="#ffffff">
    <td width="12%" align="right" valign="top"><b>Words</b></td>
    <td width="12%" align="right" valign="top"><b>Translatable</b></td>
    <td width="14%" align="right" valign="top"><b>Translated</b></td>
    <td width="12%" align="right" valign="top"><b>For&#160;Review</b></td>
    <td width="12%" align="right" valign="top"><b>Signed&#160;Off</b></td>
    <td width="14%" align="right" valign="top"><b>Not&#160;Translated</b></td>
    <td width="12%" align="right" valign="bottom"><b>Resources</b></td>
    <td width="12%" align="right" valign="bottom"><b>Segments</b></td>
</tr>
</table>
<xsl:for-each select="/xliff/file/body/group">
<xsl:choose>
<xsl:when test="@restype='folder'">
	<xsl:call-template name="folder_template">
		<xsl:with-param  name="level" >1</xsl:with-param>
	</xsl:call-template> 
</xsl:when>
<xsl:otherwise>
	<xsl:call-template name="file_template">
		<xsl:with-param  name="level" >1</xsl:with-param>
	</xsl:call-template> 
</xsl:otherwise>
</xsl:choose>

</xsl:for-each>
<br/><br/>
<xsl:call-template name="total_template"/>
</div>
</xsl:template>


<!--****************************** COMPACT VIEW ******************************-->
<xsl:template name="compact_view" >
<xsl:call-template name="compact_layer"/>
</xsl:template>




<xsl:template name="write_path_to_folder_with_icons" >
<xsl:if test="../@restype='folder'">
	<xsl:for-each select="..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each>
</xsl:if>
<img  align="absmiddle" src="Report_Styles/folderopen.gif" width="24" height="22" border="0"/><xsl:value-of select="@resname"/><xsl:text> / </xsl:text>
</xsl:template>



<xsl:template name="write_path_to_folder" >
<xsl:if test="../@restype='folder'">
	<xsl:for-each select="..">
		<xsl:call-template name="write_path_to_folder"/>
	</xsl:for-each>
</xsl:if>
<xsl:value-of select="@resname"/><xsl:text> / </xsl:text>
</xsl:template>


<!--****************************** STRINGS TEMPLATE ******************************-->
<xsl:template name="strings_template" >
<a><xsl:attribute name="name"><xsl:value-of select="@id" /></xsl:attribute></a>
<br/>
<table cellspacing="0" cellpadding="3" border="0" width="100%">
<tr class="text" >
    <td bgcolor="#696745" colspan="3"><font color="White"><b>
<xsl:choose>
<xsl:when test="../@restype='folder'">
	<xsl:for-each select="..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each>
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="@resname"/>
</xsl:when >

<xsl:when test="../../@restype ='folder'">
	<xsl:for-each select="../..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each><img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="@resname !=''">
<xsl:value-of select="@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >


<xsl:when test="../../../@restype ='folder'">
	<xsl:for-each select="../../..">
		<xsl:call-template name="write_path_to_folder_with_icons"/>
	</xsl:for-each><img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="../@resname !=''">
<xsl:value-of select="../@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="../@restype"/><xsl:text> : </xsl:text><xsl:value-of select="@resname"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >


<xsl:when test="name(..) = 'body'">
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="@resname"/>
</xsl:when >


<xsl:when test="name(../..) = 'body'">
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="@resname !=''">
<xsl:value-of select="@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >



<xsl:when test="name(../../..) = 'body'">
<img  align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><xsl:value-of select="../../@resname"/><xsl:text> / </xsl:text><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/>
<xsl:choose>
<xsl:when test="../@resname !=''">
<xsl:value-of select="../@resname"/>
</xsl:when >
<xsl:otherwise>
<xsl:value-of select="../@restype"/><xsl:text> : </xsl:text><xsl:value-of select="@resname"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when >


</xsl:choose>
</b></font></td>
	
<td valign="bottom" width="30"><a href="#top"><img alt="Top of page" src="Report_Styles/arrow_up_red.gif" width="12" height="12" border="0"/></a><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><a><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="@id" /></xsl:attribute><img src="Report_Styles/arrow_down.gif" alt="Next element" width="12" height="12" border="0"/></a></td>
</tr>
<tr>
<td colspan="3">
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="textsmall" bgcolor="#f7f7f7">
    <td width="12%" align="right" valign="top"><b>Words</b></td>
    <td width="12%" align="right" valign="top"><b>Translatable</b></td>
    <td width="14%" align="right" valign="top"><b>Translated</b></td>
    <td width="12%" align="right" valign="top"><b>For Review</b></td>
    <td width="12%" align="right" valign="top"><b>Signed Off</b></td>
    <td width="14%" align="right" valign="top"><b>Not Translated</b></td>	

    <td width="12%" align="right"><b>Resources</b></td>
    <td width="12%" align="right"><b>Segments</b></td>
</tr>
<tr class="text" bgcolor="#f7f7f7">
    <td  align="right" valign="top"><xsl:value-of select="count-group/count[@unit='words']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xable']"/></td>
    <td width="14%" align="right" valign="top">
	<xsl:value-of select="count-group/count[@count-type='x-xated']"/> <xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="count-group/count[@count-type='x-xated']*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if>
	</td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-fr']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-so']"/></td>
    <td width="14%" align="right" valign="top">
	<xsl:number value="count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated']"/> 
	<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> ( <xsl:number value="(count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated'])*100 div count-group/count[@count-type='x-xable']"/> %)</xsl:if></td>	
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='item'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='item'] !='-1'"><xsl:value-of select="count-group/count[@unit='item']"/></xsl:when>
</xsl:choose></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='segment'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='segment'] !='-1'"><xsl:value-of select="count-group/count[@unit='segment']"/></xsl:when>
</xsl:choose></td>
</tr>
</table>
</td>
<td></td>
</tr>


<tr class="text" >
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
    <td bgcolor="#ffffff" class="text"><b>Source</b></td>
    <td bgcolor="#ffffff" class="text"><b>Target</b></td>
    <td bgcolor="#ffffff" ><img src="Report_Styles/pixel.gif" width="1" height="5" border="0"/></td>
</tr>
<xsl:for-each select="trans-unit">
<tr>
<td class="text" width="6%"><xsl:value-of select="@id"/></td>
<xsl:choose>
<xsl:when test="position() mod 2 != 0">
<td class="text" bgcolor="#f7f7f7" width="45%"><xsl:value-of select="source"/></td>
<td class="text" bgcolor="#f7f7f7" width="45%"><xsl:value-of select="target"/></td>
</xsl:when>
<xsl:otherwise>
<td class="text" bgcolor="#ffffff" width="45%"><xsl:value-of select="source"/></td>
<td class="text" bgcolor="#ffffff" width="45%"><xsl:value-of select="target"/></td>
</xsl:otherwise>
</xsl:choose>


<td valign="bottom" width="4%"><xsl:if test="position() mod 5 = 0"><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Top of element" src="Report_Styles/arrow_up.gif" width="12" height="12" border="0"/></xsl:element><img src="Report_Styles/pixel.gif" width="2" height="5" border="0"/><xsl:element name="a"><xsl:attribute name="href"><xsl:text>#end</xsl:text><xsl:value-of select="../@id" /></xsl:attribute><img alt="Next element" src="Report_Styles/arrow_down.gif" width="12" height="12" border="0"/></xsl:element></xsl:if ></td>
</tr>

</xsl:for-each>
</table>
<xsl:element name="a"><xsl:attribute name="name"><xsl:text>end</xsl:text><xsl:value-of select="@id" /></xsl:attribute></xsl:element>
</xsl:template>


<!--****************************** FOLDER TEMPLATE ******************************-->
<xsl:template name="folder_template" >
<xsl:param name="level">0</xsl:param>
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="text" bgcolor="#ffffff">
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
</tr>
<tr class="text" bgcolor="#696745">
<td bgcolor="#696745" colspan="8" align="left">
<table border="0" cellpadding="0" cellspacing="0" >
<tr class="text" >
<td width="{$level}" bgcolor="White"><img src="Report_Styles/pixel.gif" width="{$level}" height="1" border="0"/></td>
    <td bgcolor="#696745" nowrap="nowrap"><img align="absmiddle" src="Report_Styles/pixel.gif" width="16" height="20" border="0"/><img align="absmiddle" src="Report_Styles/folderopen.gif" width="24" height="22" border="0"/><b><font color="white"><xsl:value-of select="@resname"/></font></b> </td>
</tr>
</table>
</td>

</tr>
<tr class="text" bgcolor="#ffffff">
    <td  align="right" valign="top"><xsl:value-of select="count-group/count[@unit='words']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xable']"/></td>
    <td width="14%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xated']"/> 
		<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="count-group/count[@count-type='x-xated']*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>

    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-fr']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-so']"/></td>
    <td width="14%" align="right" valign="top"><xsl:number value="count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated']"/> 
		<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="(count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated'])*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>

    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='item'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='item'] !='-1'"><xsl:value-of select="count-group/count[@unit='item']"/></xsl:when>
</xsl:choose></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='segment'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='segment'] !='-1'"><xsl:value-of select="count-group/count[@unit='segment']"/></xsl:when>
</xsl:choose></td>


</tr>
</table>
<!--<div style="position:relative; width:100%; height:10px; z-index:1 "><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></div>-->
<!--<font size="1"><br/></font>-->
<xsl:for-each select="child::*">
	<xsl:if test = "@restype='folder'" > 
			<xsl:call-template name="folder_template">
				<xsl:with-param  name="level" ><xsl:value-of select="$level+12"/></xsl:with-param>
			</xsl:call-template> 
    </xsl:if> 
	<xsl:if test = "@restype !='folder'" > 
			<xsl:call-template name="file_template">
				<xsl:with-param  name="level" ><xsl:value-of select="$level+12"/></xsl:with-param>
				<xsl:with-param  name="id" ><xsl:value-of select="@id"/></xsl:with-param>
			</xsl:call-template> 
    </xsl:if> 
</xsl:for-each>
</xsl:template>

<!--****************************** FILE TEMPLATE ******************************-->
<xsl:template name="file_template" >
<xsl:param name="level">0</xsl:param>
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="text" bgcolor="#ffffff">
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
</tr>
<tr class="text" bgcolor="#f7f7f7">
<td bgcolor="#f7f7f7" colspan="8">
<table border="0" cellpadding="0" cellspacing="0">
<tr class="text">
	<td width="{$level}" bgcolor="White"><img src="Report_Styles/pixel.gif" width="{$level}" height="1" border="0"/></td>
    <td bgcolor="#f7f7f7" nowrap="nowrap"><b><xsl:value-of select="ancestor"/></b>
<xsl:choose>
<xsl:when test="boolean(./group)">
<a  onFocus="if(this.blur)this.blur();">
<xsl:attribute name="href"><xsl:text>Javascript:ExpandLayer('</xsl:text><xsl:value-of select="@id"/><xsl:text>')</xsl:text></xsl:attribute><img align="absmiddle" src="Report_Styles/pnode.gif" width="16" height="20" border="0"><xsl:attribute name="name"><xsl:text>icon</xsl:text><xsl:value-of select="@id"/></xsl:attribute></img><img align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><b><xsl:choose><xsl:when test="@resname !=''"><xsl:value-of select="@resname"/></xsl:when><xsl:otherwise><xsl:value-of select="@restype"/></xsl:otherwise></xsl:choose></b></a> 
</xsl:when>
<xsl:otherwise>
<img align="absmiddle" src="Report_Styles/pixel.gif" width="16" height="20" border="0"/><img align="absmiddle" src="Report_Styles/doc.gif" width="24" height="22" border="0"/><b><xsl:choose><xsl:when test="@resname !=''"><xsl:value-of select="@resname"/></xsl:when><xsl:otherwise><xsl:value-of select="@restype"/></xsl:otherwise></xsl:choose></b>
</xsl:otherwise>
</xsl:choose>
</td>
</tr>
</table></td>
	
</tr>
<tr class="text" >
    <td  align="right" valign="top"><xsl:value-of select="count-group/count[@unit='words']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xable']"/></td>
    <td width="14%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xated']"/> 
		<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="count-group/count[@count-type='x-xated']*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-fr']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-so']"/></td>
    <td width="14%" align="right" valign="top"><xsl:number value="count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated']"/> 
	<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="(count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated'])*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>	
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='item'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='item'] !='-1'"><xsl:value-of select="count-group/count[@unit='item']"/></xsl:when>
</xsl:choose></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='segment'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='segment'] !='-1'"><xsl:value-of select="count-group/count[@unit='segment']"/></xsl:when>
</xsl:choose></td>
</tr>
</table>
<div style="position:relative; width:100%; height:1px; z-index:1; overflow: hidden; visibility:hidden">
<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
<xsl:for-each select="./group">
			<xsl:call-template name="resource_template">
				<xsl:with-param  name="level" ><xsl:value-of select="$level+12"/></xsl:with-param>
			</xsl:call-template> 
</xsl:for-each>
</div>
</xsl:template>


<!--****************************** RESOURCE TEMPLATE ******************************-->
<xsl:template name="resource_template" >
<xsl:param name="level">0</xsl:param>
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="text" bgcolor="#ffffff">
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
</tr>
<tr class="text" >
<td bgcolor="#f7f7f7" colspan="8">
<table border="0" cellpadding="0" cellspacing="0">
<tr class="text">
	<td width="{$level}" bgcolor="White"><img src="Report_Styles/pixel.gif" width="{$level}" height="1" border="0"/></td>
    <td bgcolor="#f7f7f7" nowrap="nowrap">
<xsl:choose>
<xsl:when test="boolean(./group)">
<a onFocus="if(this.blur)this.blur();"><xsl:attribute name="href"><xsl:text>Javascript:ExpandLayer('</xsl:text><xsl:value-of select="@id"/><xsl:text>')</xsl:text></xsl:attribute><img align="absmiddle" src="Report_Styles/pnode.gif" width="16" height="20" border="0"><xsl:attribute name="name"><xsl:text>icon</xsl:text><xsl:value-of select="@id"/></xsl:attribute></img><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/> <b>
<xsl:choose>
<xsl:when test="@resname != ''">
<xsl:value-of select="@resname"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>


</b></a> 
</xsl:when>
<xsl:otherwise>
<img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/> <b>
<xsl:choose>
<xsl:when test="@resname != ''">
<xsl:value-of select="@resname"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</b>
</xsl:otherwise>
</xsl:choose>

</td>
</tr>
</table></td>

</tr>
<tr class="text" bgcolor="#ffffdf">
<td>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
<tr class="text" bgcolor="#ffffdf">
	<td width="{$level}" bgcolor="White"><a href=""><img src="Report_Styles/pixel.gif" width="{$level}" height="1" border="0"/></a></td>
    <td  align="right" valign="top"><xsl:value-of select="count-group/count[@unit='words']"/></td>
</tr>
</table></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xable']"/></td>
    <td width="14%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xated']"/> 
		<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="count-group/count[@count-type='x-xated']*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>
    <td width="14%" align="right" valign="top"><xsl:number value="count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated']"/> 
		<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="(count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated'])*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-fr']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-so']"/></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='item'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='item'] !='-1'"><xsl:value-of select="count-group/count[@unit='item']"/></xsl:when>
</xsl:choose></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='segment'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='segment'] !='-1'"><xsl:value-of select="count-group/count[@unit='segment']"/></xsl:when>
</xsl:choose></td>
</tr>
</table>
<div style="position:relative; width:100%; height:1px; z-index:1; overflow: hidden; visibility:hidden">
<xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
<xsl:for-each select="./group">
			<xsl:call-template name="sub_resource_template">
				<xsl:with-param  name="level" ><xsl:value-of select="$level+12"/></xsl:with-param>
			</xsl:call-template> 
</xsl:for-each>
</div>
</xsl:template>




<!--****************************** SUB RESOURCE TEMPLATE ******************************-->
<xsl:template name="sub_resource_template" >
<xsl:param name="level">0</xsl:param>
<table width="100%" border="0" cellspacing="0" cellpadding="0" >
<tr class="text" bgcolor="#ffffff">
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="14%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
    <td width="12%" align="right"></td>
</tr>
<tr class="text" >
<td bgcolor="#f7f7f7" colspan="8">
<table border="0" cellpadding="0" cellspacing="0">
<tr class="text">
	<td width="{$level}" bgcolor="White"><img src="Report_Styles/pixel.gif" width="{$level}" height="1" border="0"/></td>
    <td bgcolor="#f7f7f7" nowrap="nowrap"><img align="absmiddle" src="Report_Styles/resource.gif" width="16" height="17" border="0" hspace="5"/> <b>

<xsl:choose>
<xsl:when test="@resname != ''">
<xsl:value-of select="@resname"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="@restype"/>
</xsl:otherwise>
</xsl:choose>
</b> </td>
</tr>
</table></td>

</tr>
<tr class="text" bgcolor="#e8ffff">
<td>
<table border="0" cellpadding="0" cellspacing="0" width="100%">
<tr class="text" bgcolor="#e8ffff">
	<td width="{$level}" bgcolor="White"><img src="Report_Styles/pixel.gif" width="{$level}" height="1" border="0"/></td>
    <td  align="right"><xsl:value-of select="count-group/count[@unit='words']"/></td>
</tr>
</table></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xable']"/></td>
    <td width="14%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-xated']"/> 
		<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="count-group/count[@count-type='x-xated']*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>
    <td width="14%" align="right" valign="top"><xsl:number value="count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated']"/> 
	<xsl:if test="count-group/count[@count-type='x-xable'] !='0'"> (&#160;<xsl:number value="(count-group/count[@count-type='x-xable'] - count-group/count[@count-type='x-xated'])*100 div count-group/count[@count-type='x-xable']"/>&#160;%)</xsl:if></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-fr']"/></td>
    <td width="12%" align="right" valign="top"><xsl:value-of select="count-group/count[@count-type='x-so']"/></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='item'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='item'] !='-1'"><xsl:value-of select="count-group/count[@unit='item']"/></xsl:when>
</xsl:choose></td>
    <td width="12%" align="right" valign="top"><xsl:choose>
<xsl:when test="count-group/count[@unit='segment'] ='-1'"></xsl:when>
<xsl:when test="count-group/count[@unit='segment'] !='-1'"><xsl:value-of select="count-group/count[@unit='segment']"/></xsl:when>
</xsl:choose></td>
</tr>
</table>
<xsl:for-each select="./group">
			<xsl:call-template name="resource_template">
				<xsl:with-param  name="level" ><xsl:value-of select="$level+12"/></xsl:with-param>
			</xsl:call-template> 
</xsl:for-each>
</xsl:template>







</xsl:stylesheet>